// // // // // // // // // // // // // // // // // // // //
//	
//	Sensor
//	
//	created Apr/14/98 by Andreas Warnke
//	last mod Mai/17/98 by Andreas Warnke
//



// // // // // // // // // // // // // // // // // // // //
//	
//	#include
//

#include <Be.h>
#include "ConnectionData.h"
#include "AsciiKette.h"
#include "Sensor.h"
#include "GlobalVariables.h"



// // // // // // // // // // // // // // // // // // // //
//	
//	Constructor
//

Sensor :: Sensor ()
{
	//	Nothing to do.
};



// // // // // // // // // // // // // // // // // // // //
//	
//	Destructor:
//

Sensor :: ~Sensor ()
{
	//	Nothing to do.
};



// // // // // // // // // // // // // // // // // // // //
//	
//	MessageReceived:
//

void Sensor :: MessageReceived ( BMessage * inMessage )
{
	if ( inMessage -> what == eInterApplicationMessage )
	{
		//	Check Password:
		if ( ! Equal ( inMessage -> FindString ( "ClientName" ), TheName ) )
			//	This Message is not for me!
			return;
		if ( ! Equal ( inMessage -> FindString ( "Password" ), ThePassword ) )
			//	This Message was not sent by the Server!
			return;
			
		//	Check Message Type and call appropriate Method:
		if ( Equal ( inMessage -> FindString ( "Type" ), "status" ) )
			StatusMessageReceived ( inMessage );
		else if ( Equal ( inMessage -> FindString ( "Type" ), "welcome" ) )
			WelcomeMessageReceived ( inMessage );
		else if ( Equal ( inMessage -> FindString ( "Type" ), "victory" ) )
			VictoryMessageReceived ( inMessage );
		else if ( Equal ( inMessage -> FindString ( "Type" ), "error" ) )
			ErrorMessageReceived ( inMessage );
		else
		{
			//	Message of unknown type received.
		};
	}
	else
		//	ask daddy what to do:
		BLooper :: MessageReceived ( inMessage );
};



// // // // // // // // // // // // // // // // // // // //
//	
//	WelcomeMessageReceived:
//

void Sensor :: WelcomeMessageReceived ( BMessage * inMessage )
{
	//	Extract ConnectionData - Values:
	LoggedIn = true;
	ThePlayerID = inMessage -> FindInt32 ( "ClientID" );
	
	//	Call virtual Methods:
	ProtocolVersionReceived ( inMessage -> FindInt32 ( "Version" ) );
	ClientIDReceived ( ThePlayerID );
	unsigned int sMapSize = inMessage -> FindInt32 ( "MapSize" );
	MapSizeReceived ( sMapSize, sMapSize );
};



// // // // // // // // // // // // // // // // // // // //
//	
//	StatusMessageReceived:
//

void Sensor :: StatusMessageReceived ( BMessage * inMessage )
{
	//	Get Server Time:
	bigtime_t sCurrentServerTime;
	if ( inMessage -> FindInt64 ( "CurrentTime", & sCurrentServerTime ) >= B_NO_ERROR )
		ServerTimeReceived ( sCurrentServerTime );
	else
		sCurrentServerTime = real_time_clock_usecs ();
		
	//	Get Fields:
	int sIndex = 0;
	BMessage sField;
	while ( inMessage -> FindMessage ( "Field", sIndex, & sField ) >= B_NO_ERROR )
	{
		unsigned int sFieldType = sField . FindInt32 ( "Type" );
		int sFieldX = sField . FindInt32 ( "XPos" );
		int sFieldY = sField . FindInt32 ( "YPos" );
		if ( sFieldType == eInvisible )
			InvisibleFieldReceived ( sFieldX, sFieldY );
		else
			VisibleFieldReceived ( sFieldX, sFieldY, sFieldType );
		sIndex ++;
	};
	
	//	Get Objects:
	sIndex = 0;
	BMessage sObject;
	while ( inMessage -> FindMessage ( "Object", sIndex, & sObject ) >= B_NO_ERROR )
	{
		bigtime_t sBusyTill = 0;
		sObject . FindInt64 ( "BusyTill", & sBusyTill );
		ObjectReceived (
			sObject . FindInt32 ( "ID" ),
			sObject . FindInt32 ( "Type" ),
			sObject . FindInt32 ( "Owner" ),
			sBusyTill,
			( sBusyTill >= sCurrentServerTime ),
			sObject . FindInt32 ( "XPos" ),
			sObject . FindInt32 ( "YPos" ),
			sObject . FindBool ( "SensorData" ) );
		sIndex ++;
	};
};



// // // // // // // // // // // // // // // // // // // //
//	
//	VictoryMessageReceived:
//

void Sensor :: VictoryMessageReceived ( BMessage * inMessage )
{
	//	Extract ConnectionData - Values:
	GameFinished = true;
	
	//	Call virtual functions:
	VictoryReceived (
		inMessage -> FindInt32 ( "ID" ),
		inMessage -> FindString ( "Name" ) );
};



// // // // // // // // // // // // // // // // // // // //
//	
//	ErrorMessageReceived:
//

void Sensor :: ErrorMessageReceived ( BMessage * inMessage )
{
	//	Extract ConnectionData - Values:
	int sErrorCode = inMessage -> FindInt32 ( "ErrorCode" );
	if ( ( sErrorCode == eServerRefusesLogin )
		|| ( sErrorCode == eIncompatibleVersions )
		|| ( sErrorCode == eMapTooSmall )
		|| ( sErrorCode == eOutOfMemoryNotLoggedIn )
		|| ( sErrorCode == eWrongPasswordNotLoggedIn ) )
		//	I'm not logged in.
		LoggedIn = false;
	
	//	Call virtual functions:
	ErrorReceived ( sErrorCode, inMessage -> FindString ( "ErrorText" ) );
};



// // // // // // // // // // // // // // // // // // // //
//	
//	Count all waiting messages:
//

unsigned int Sensor :: CountAllWaitingMessages ( team_id inTeam )
{
	//	initialization:
	unsigned int sAll = 0;
	port_info sInfo;
	long sCookie = 0;
	
	//	Collect Messages:
	while ( get_next_port_info ( inTeam, & sCookie, & sInfo ) >= B_NO_ERROR )
		sAll = sAll + sInfo . queue_count;
	
	//	ready:
	return sAll;
};



//	
//	The End.
//	
// // // // // // // // // // // // // // // // // // // //